//
//  CRInplaceEditorDescriptor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRInplaceEditorController;

//////////////////////////////////////////////////////////////////////
// Inplace editor
//////////////////////////////////////////////////////////////////////
@interface CRInplaceEditorDescriptor : NSObject
{
	NSString*	name;
	NSImage*	icon;
	Class		controllerClass;
}

@property (readonly) NSString*	name;
@property (readonly) NSImage*	icon;
@property (readonly) Class		controllerClass;

- (id)initWithName:(NSString *)aName icon:(NSImage *)anIcon controllerClass:(Class)aClass;
+ (id)inplaceEditorDescriptorWithName:(NSString *)aName icon:(NSImage *)anIcon controllerClass:(Class)aClass;
+ (id)emptyEditor;

- (CRInplaceEditorController *)controllerForObject:(id)rootObject;
- (NSString *)description;

@end